/* @(#)ttys.h	1.9 04/03/12 Copyright 1984-2004 J. Schilling */
/*
 *	Definitione for the internal lower layer support for terminal.h
 *
 *	Copyright (c) 1984-2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * The external interface of ttycmds.c has the following functions:
 *
 *	tty_start()	- Parse TERMCAP entry and do set up for this package
 *	tty_entry(i)	- Return pointer to decoded TERMCAP entries
 *	tty_fkey(i)	- Return TERMCAP mapping for function key 'i'
 *	tty_pagesize()	- Return the terminal's pagesize from TERMCAP entry
 *	tty_linelength()- Return the terminal's linelength from TERMCAP entry
 *	tty_init()	- Initialize terminal (send startup sequence)
 *	tty_term()	- Restore terminal to default mode (send term sequence)
 *
 *	TTY*		- Several pointers to apropriate functions
 *			  implementing TERMCAP functionality.
 *			  These pointers are not intended for direct use by the
 *			  higher level software but for terminal.c
 *
 * If a specific TERMCAP functionality is not present the corresponding
 * TTY* function pointer is a NULL pointer.
 *
 * tty_pagesize() and tty_linelength() return the "real" size of the
 * screen as returnd by tgetent(). Corrections for "auto_right_margin"
 * are done in the upper layers.
 */

extern	void (*TTYclrscreen)	__PR((ewin_t *wp));	/* clr screen */
extern	void (*TTYclr_endscr)	__PR((ewin_t *wp));	/* clr to end of scr */
extern	void (*TTYclrendln)	__PR((void));		/* clr to end of line*/
extern	void (*TTYdelchars)	__PR((int));		/* delete chars */
extern	void (*TTYdellines)	__PR((int));		/* delete lines */
extern	void (*TTYinschars)	__PR((char *));		/* insert chars */
extern	void (*TTYinslines)	__PR((int));		/* insert lines */
extern	void (*TTYaltvideo)	__PR((char *));		/* alternate video */
extern	void (*TTYhome)		__PR((void));		/* cursor home */
extern	void (*TTYup)		__PR((int));		/* cursor up */
extern	void (*TTYdown)		__PR((int));		/* cursor down */
extern	void (*TTYleft)		__PR((int));		/* cursor left */
extern	void (*TTYright)	__PR((int));		/* cursor right */
extern	void (*TTYcursor)	__PR((int y, int x));	/* move cursor abs */
extern	void (*TTYsscroll)	__PR((int, int));	/* set scroll region */
extern	void (*TTYsup)		__PR((int));		/* scroll up */
extern	void (*TTYsdown)	__PR((int));		/* scroll down */


extern	char *	tty_start	__PR((int (*)(int c)));
extern	char **	tty_entry	__PR((void));
extern	void	tty_init	__PR((void));
extern	void	tty_term	__PR((void));
extern	char *	tty_fkey	__PR((int n));
extern	int	tty_pagesize	__PR((void));
extern	int	tty_linelength	__PR((void));
