/* @(#)consdebug.c	1.17 04/03/13 Copyright 1986-2004 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)consdebug.c	1.17 04/03/13 Copyright 1986-2004 J. Schilling";
#endif
/*
 *	Print debugging messages to the console or to "VED_DBGTERM" environment
 *
 *	Copyright (c) 1986-2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <standard.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <fctldefs.h>
#include <strdefs.h>
#include <vadefs.h>
#include <schily.h>

EXPORT	void	cdbg		__PR((char *fmt, ...));
EXPORT	void	writecons	__PR((char *s));
EXPORT	long	getcaller	__PR((void));

#ifndef	DEBUG
#define	DEBUG
#endif
/*#define	DEBUG_CALLER*/
#if !defined(sun)
#undef	DEBUG_CALLER
#endif

#ifdef	DEBUG

#ifdef	DEBUG_CALLER
#ifdef	FOPEN_MAX
#if	defined(__sun) && defined(__i386)
#include <sys/reg.h>
#endif
#include <sys/frame.h>		/* Bug in SYSV frame.h ist Prozessorabhngig*/
#else
#include <machine/frame.h>
#endif
#endif

/*
 * Do formatted debugging output to the console
 */
/* PRINTFLIKE1 */
#ifdef	PROTOTYPES
EXPORT void
cdbg(char *fmt, ...)
#else
EXPORT void
cdbg(fmt, va_alist)
	char	*fmt;
	va_dcl
#endif
{
	char	buf[200];
	va_list	args;

#ifdef	PROTOTYPES
	va_start(args, fmt);
#else
	va_start(args);
#endif
	snprintf(buf, sizeof (buf), "%r", fmt, args);
	va_end(args);
	writecons(buf);
}

/*
 * Write to the console or to "VED_DBGTERM" environment.
 * Open and close the device for every access.
 */
EXPORT void
writecons(s)
	char	*s;
{
	static	int	f;
		char	*cname;

	if (f == 0) {
		if ((cname = getenv("VED_DBGTERM")) == NULL)
			cname = "/dev/console";

		f = open(cname, 1);
		if (f == 0)
			return;
	}

	write(f, s, strlen(s));
	write(f, "\n", 1);
}

/*
 * Try to get calling function's address
 */
#ifdef	DEBUG_CALLER
EXPORT long
getcaller()
{
	/*
	 * Return saved pc of previous frame to getcaller()
	 * As the SCO OpenServer C-Compiler has a bug that may cause
	 * the first function call to getfp() been done before the
	 * new stack frame is created, we call getfp() twice.
	 */
	(void) getfp();
/*	return (((struct frame *)getfp())->fr_savfp->fr_savpc);*/
	return (((struct frame *)(((struct frame *)getfp())->fr_savfp))->fr_savpc);
}
#else
EXPORT long
getcaller()
{
	return (0);
}
#endif

#else

/* ARGSUSED */
#ifdef	PROTOTYPES
EXPORT void
cdbg(char *fmt, ...)
#else
EXPORT void
cdbg(fmt, va_alist)
	char	*fmt;
	va_dcl
#endif
{
}

/* ARGSUSED */
EXPORT void
writecons(s)
	char	*s;
{
}

EXPORT long
getcaller()
{
	return (0);
}

#endif
