/* @(#)filereopen.c	1.11 00/12/04 Copyright 1986, 1995 J. Schilling */
/*
 *	open new file on old stream
 *
 *	Copyright (c) 1986, 1995 J. Schilling
 */
/*@@C@@*/

#include "io.h"

/*
 * XXX We need to switch to fseeko()/ftello() sometime in the future.
 * XXX See io.h hack.
 */

LOCAL	char	*fmtab[] = {
			"",	/* 0	FI_NONE				*/
			"r",	/* 1	FI_READ				*/
			"r+",	/* 2	FI_WRITE		**1)	*/
			"r+",	/* 3	FI_READ  | FI_WRITE		*/
			"b",	/* 4	FI_NONE  | FI_BINARY		*/
			"rb",	/* 5	FI_READ  | FI_BINARY		*/
			"r+b",	/* 6	FI_WRITE | FI_BINARY	**1)	*/
			"r+b",	/* 7	FI_READ  | FI_WRITE | FI_BINARY	*/
		};
/*
 * NOTES:
 *	1)	there is no fopen() mode that opens for writing
 *		without creating/truncating at the same time.
 *
 *	"w"	will create/trunc files with fopen()
 *	"a"	will create files with fopen()
 */

EXPORT FILE *
filereopen(name, mode, fp)
	const char	*name;
	const char 	*mode;
	FILE		*fp;
{
	int	ret;
	int	omode = 0;
	int	flag = 0;

	if (!_cvmod (mode, &omode, &flag))
		return ((FILE *) NULL);

	/*
	 * create/truncate file if necessary
	 */
	if ((ret = _openfd(name, omode)) < 0)
		return ((FILE *) NULL);
	close(ret);

	fp = freopen(name, fmtab[flag & (FI_READ | FI_WRITE | FI_BINARY)], fp);
	if (fp != (FILE *) NULL) {
		set_my_flag(fp, 0); /* must clear it if fp is reused */

		if (flag & FI_APPEND) {
			(void) fseek(fp, (off_t)0, SEEK_END);
		}
		if (flag & FI_UNBUF) {
			setbuf(fp, NULL);
			add_my_flag(fp, _IOUNBUF);
		}
	}
	return (fp);
}
