/* @(#)vedstats.c	1.2 00/12/17 Copyright 2000 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)vedstats.c	1.2 00/12/17 Copyright 2000 J. Schilling";
#endif
/*
 *	Statistics module for VED (Visual EDitor)
 *
 *	Copyright (c) 2000 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ved.h"
#include <signal.h>
#include <setjmp.h>
#include <jmpdefs.h>

EXPORT	long	charstyped;

EXPORT	void	vedstartstats	__PR((void));
EXPORT	void	vedstopstats	__PR((void));
EXPORT	void	vedstatistics	__PR((void));

#ifdef	VED_STATS

#ifdef	HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef	HAVE_SYS_TIMES_H
#include <sys/times.h>
#endif

#ifndef	CLK_TCK
#define	CLK_TCK	60
#endif

#ifdef	HAVE_TIMES
LOCAL	struct tms	stms;
LOCAL	struct tms	etms;
#endif

EXPORT void
vedstartstats()
{
#ifdef	HAVE_TIMES
	times(&stms);
#endif
}

EXPORT void
vedstopstats()
{
#ifdef	HAVE_TIMES
	times(&etms);
#endif
}

EXPORT void
vedstatistics()
{
#ifdef	HAVE_TIMES
	struct tms	tms;
	long		usecs;
#endif

	if (getenv("VED_STATISTICS") == NULL)
		return;

#ifdef	HAVE_TIMES
	times(&tms);

	error("input chars %ld\n", charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_utime;
	error("user time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_stime;
	error("sys  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= (tms.tms_utime + tms.tms_stime);
	error("sum  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);

	error("witout load time:\n");
	tms.tms_utime -= stms.tms_utime;
	tms.tms_stime -= stms.tms_stime;

	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_utime;
	error("user time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_stime;
	error("sys  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= (tms.tms_utime + tms.tms_stime);
	error("sum  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);

	error("witout save time:\n");
	tms.tms_utime = etms.tms_utime - stms.tms_utime;
	tms.tms_stime = etms.tms_stime - stms.tms_stime;

	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_utime;
	error("user time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= tms.tms_stime;
	error("sys  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
	usecs = 1000000 / CLK_TCK;
	usecs *= (tms.tms_utime + tms.tms_stime);
	error("sum  time %8ld s %5ld s/char\n",
		usecs, usecs/charstyped);
#endif
}

#else

EXPORT void
vedstartstats()
{
}

EXPORT void
vedstopstats()
{
}

EXPORT void
vedstatistics()
{
}

#endif	/* VED_STATS */
