/* @(#)ctab.c	1.11 00/12/13 Copyright 1986 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)ctab.c	1.11 00/12/13 Copyright 1986 J. Schilling";
#endif
/*
 *	Character string and stringlength tables for screen
 *	output functions.
 *
 *	Copyright (c) 1986 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ved.h"

EXPORT	Uchar	csize[256];
EXPORT	Uchar	*ctab[256];

LOCAL	Uchar	*cmakestr	__PR((ewin_t *wp, Uchar* s));
EXPORT	void	init_charset	__PR((ewin_t *wp));
LOCAL	void	init_csize	__PR((ewin_t *wp));
LOCAL	void	init_ctab	__PR((ewin_t *wp));

LOCAL Uchar *
cmakestr(wp, s)
		 ewin_t	*wp;
	register Uchar	*s;
{
		 Uchar	*tmp;
	register Uchar	*s1;

	if((tmp = (Uchar *) malloc(strlen(C s)+1)) == NULL){
		rsttmodes(wp);
		raisecond("makstr", 0L);
	}
	for(s1 = tmp; (*s1++ = *s++) != '\0' ; );
	return(tmp);
}

EXPORT void
init_charset(wp)
	ewin_t	*wp;
{
	init_ctab(wp);
	init_csize(wp);
}

LOCAL void
init_csize(wp)
	ewin_t	*wp;
{
	register unsigned c;
	register Uchar	*rcsize = csize;

	for (c=0; c <= 255 ; c++, rcsize++){
		if (c < SP || c == DEL)			/*ctl*/
			*rcsize = 2;
		else if ((c > DEL && c < SP8) || c == DEL8)/*8bit ctl*/
			*rcsize = 3;
		else if (c >= SP8 && !wp->raw8)		/*8bit norm*/
			*rcsize = 2;
		else					/*7bit norm*/
			*rcsize = 1;
	}
}

LOCAL char chpre[] = " ";
LOCAL char ctlpre[] = "^ ";
LOCAL char eightpre[] = "~ ";
LOCAL char eightctlpre[] = "~^ ";

LOCAL void
init_ctab(wp)
	ewin_t	*wp;
{
	register unsigned c;
	register Uchar	*p;
	register Uchar	**rctab	= ctab;
	register Uchar	*ch	= (Uchar *) chpre;
	register Uchar	*ctl	= (Uchar *) ctlpre;
	register Uchar	*eight	= (Uchar *) eightpre;
	register Uchar	*eightctl = (Uchar *) eightctlpre;
 

	for (c=0; c <= 255 ; c++, rctab++){
		if (c < SP || c == DEL){		/* ctl char */
			p = cmakestr (wp, ctl);
			p[1] = c ^ 0100;
		} else if ((c > DEL && c < SP8) || c == DEL8){/* 8 bit ctl */
			p = cmakestr (wp, eightctl);
			p[2] = c ^ 0300;
		} else if (c >= SP8 && !wp->raw8){	/* 8 bit char */
			p = cmakestr (wp, eight);
			p[1] = c & 0177;
		} else {				/* normal char */
			p = cmakestr (wp, ch);
			p[0] = (Uchar)c;
		}
		*rctab = p;
	}
}
