/* @(#)filesize.c	1.10 00/12/03 Copyright 1986 J. Schilling */
/*
 *	Copyright (c) 1986 J. Schilling
 */
/*@@C@@*/

#include "io.h"
#include <sys/types.h>
#include <sys/stat.h>

EXPORT off_t
filesize (f)
	register FILE	*f;
{
	struct stat buf;

	down(f);
	if (fstat(fileno(f), &buf) < 0){
		raisecond("filesize", 0L);
		return -1;
	}
	return (buf.st_size);
}
