/* @(#)fcons.c	2.12 00/12/04 Copyright 1986, 1995 J. Schilling */
/*
 *	Copyright (c) 1986, 1995  J. Schilling
 */
/*@@C@@*/

#include "io.h"

/*
 * XXX We need to switch to fseeko()/ftello() sometime in the future.
 * XXX See io.h hack.
 */

LOCAL	char	*fmtab[] = {
			"",	/* 0	FI_NONE				*/
			"r",	/* 1	FI_READ				*/
			"w",	/* 2	FI_WRITE		**1)	*/
			"r+",	/* 3	FI_READ  | FI_WRITE		*/
			"b",	/* 4	FI_NONE  | FI_BINARY		*/
			"rb",	/* 5	FI_READ  | FI_BINARY		*/
			"wb",	/* 6	FI_WRITE | FI_BINARY	**1)	*/
			"r+b",	/* 7	FI_READ  | FI_WRITE | FI_BINARY	*/
		};
/*
 * NOTES:
 *	1)	fdopen() guarantees not to create/trunc files in this case
 *
 *	"w"	will create/trunc files with fopen()
 *	"a"	will create files with fopen()
 */


EXPORT FILE *
_fcons(fd, f, flag)
	register FILE	*fd;
		 int	f;
		 int	flag;
{
	int	my_gflag = _io_glflag;

	if (fd == (FILE *)NULL)
		fd = fdopen(f, fmtab[flag&(FI_READ|FI_WRITE|FI_BINARY)]);

	if (fd != (FILE *)NULL) {
		if (flag & FI_APPEND) {
			(void) fseek(fd, (off_t)0, SEEK_END);
		}
		if (flag & FI_UNBUF) {
			setbuf(fd, NULL);
			my_gflag |= _IOUNBUF;
		}
		set_my_flag(fd, my_gflag); /* must clear it if fd is reused */
		return (fd);
	}
	if (flag & FI_CLOSE)
		close(f);

	return ((FILE *) NULL);
}
