/* @(#)unls.h	1.8 06/10/10 Copyright 2000-2005 J. Schilling */
/*
 *	Definitions fur users of libunls
 *
 *	Copyright (c) 2000-2005 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#ifndef _SCHILY_UNLS_H
#define	_SCHILY_UNLS_H

#ifndef _SCHILY_MCONFIG_H
#include <schily/mconfig.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

struct unls_unicode {
	unsigned char	unls_low;		/* Low Byte */
	unsigned char	unls_high;		/* High Byte */
};

struct unls_table {
	char		*unls_name;		/* UNLS charset name	*/
	unsigned char 	**unls_uni2cs;		/* Unicode -> Charset	*/
	struct unls_unicode *unls_cs2uni;	/* Charset -> Unicode	*/
	struct unls_table *unls_next;		/* Next table		*/
};

extern int		init_unls		__PR((void));
extern int		register_unls		__PR((struct unls_table *));
extern int		unregister_unls		__PR((struct unls_table *));
extern struct unls_table *find_unls		__PR((char *));
extern void		list_unls		__PR((void));
extern struct unls_table *load_unls		__PR((char *));
extern void 		unload_unls		__PR((struct unls_table *));
extern struct unls_table *load_unls_default	__PR((void));
extern int		init_unls_file		__PR((char * name));

#ifdef	__cplusplus
}
#endif

#endif	/* _SCHILY_UNLS_H */
