#!/bin/sh
###############################################################################
#
# The shell variables CFLAGS & LDFLAGS may be used to pass additional flags
# to the compile and link process.
#
###############################################################################

#
# Check if the current system allows to create symlinks
# If not, it seems that all symlinks appear to be plain files of size 0
#
echo "Checking for rotten symlinks..."
if [ ! -s make.c ]; then
	echo "Copying files because symlinks do not work..."
	sh rmlinks
	sh cpfiles
fi

SYSTEM=unknown
echo 'testing for uname...'
uname > /dev/null 2> /dev/null
if [ $? = 0 ]; then
	SYSTEM=`uname -s`
fi

CC=cc
CF=
LF=

echo 'Trying to find GCC'

gcc -v 2> /dev/null && CC=gcc

if [ $CC = gcc ]; then
	OPT=-O
else
	if [ $SYSTEM = HP-UX ]; then
		CF=-Ae
	fi
fi

#
# Set dynamic linking and auto .exe suffix for OS/2
#
if [ $SYSTEM = OS/2 ]; then
	LF="-Zexe -Zcrtdll"
fi
#
# Set stack size to 256k on QNX
#
if [ $SYSTEM = QNX ]; then 
	LF="-N 256k"
fi 

echo "SYSTEM:		$SYSTEM"
echo "CC:		$CC"
echo "OPT:		$OPT"
echo "CFLAGS:		$CF"

if [ .$CF != . ]; then
	eval CC=$CC CFLAGS=$CF sh ./configure
else
	eval CC=$CC sh ./configure
fi

set -x

$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   make.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   readfile.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   parse.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   update.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   rules.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   archconf.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   memory.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   astoi.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   comerr.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   error.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   format.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   jsprintf.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   printf.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   sprintf.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   saveargs.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   strcatl.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   streql.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   getargs.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   geterrno.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   movebytes.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   fillbytes.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   raisecond.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   fileopen.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   fcons.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   cvmod.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   flag.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   dat.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   filewrite.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   fileread.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   fileseek.c
$CC $OPT $CF $CFLAGS -c -Iinclude -I. -DNO_FLOATINGPOINT -DNO_SCANSTACK -DNO_USG_STDIO   niread.c
$CC $LF $LDFLAGS -o smake make.o readfile.o parse.o update.o rules.o archconf.o memory.o  astoi.o comerr.o error.o  format.o  jsprintf.o  printf.o sprintf.o  saveargs.o strcatl.o  streql.o getargs.o geterrno.o  movebytes.o fillbytes.o raisecond.o  fileopen.o fcons.o cvmod.o flag.o dat.o  filewrite.o fileread.o fileseek.o niread.o
