/* @(#)make.h	1.48 00/01/04 Copyright 1985 J. Schilling */
/*
 *	Definitions for make.
 *	Copyright (c) 1985 by J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

typedef	unsigned char	Uchar;
typedef unsigned long	date_t;

#define NOTIME		((date_t)0)	/* Obj not (yet) found   */
#define BADTIME		((date_t)-1)	/* Obj could not be made */
#define RECURSETIME	((date_t)-2)	/* Obj depends on itself */

					/* NOTE: MAXLEVEL must be odd */
#define MAXLEVEL	255		/* Obj is not yet searched for */
#define WDLEVEL		0		/* Obj is in working dir (".") */
#define OBJLEVEL	1		/* Obj is in .OBJDIR */

#define SSRC		1		/* Search in source directories	*/
#define SOBJ		2		/* Search in obj directories */
#define SALL		(SSRC | SOBJ)	/* Search in source/obj directories */

#ifdef	pdp11
#define NAMEMAX		512		/* Max size of a name	*/
#else
#define NAMEMAX		1024		/* Max size of a name	*/
#endif

/*
 * one unique element is used for each target or member in a dependency list
 * also used for macros and macro definition lists
 */
typedef struct obj {
	struct	obj	*o_left;	/* Left next node in binary tree    */
	struct	obj	*o_right;	/* Right next node in binary tree   */
	struct	list	*o_list;	/* List of dependencies for target  */
	struct	cmd	*o_cmd;		/* List of commands for this target */
		char	*o_name;	/* Name of this target		    */
		date_t	o_date;		/* Current date for this target	    */
		short	o_type;		/* Type of node			    */
		short	o_flags;	/* Flags for this node		    */
		short	o_level;	/* Obj level this target was found  */
		short	o_fileindex;	/* Makefile idx for this definition */
} obj_t;

#define	F_READONLY	1
#define	F_EXPORT	2
#define	F_MULTITARGET	8

/*
 * list element, used to build dependency lists from unique obj elements
 */
typedef struct list {
	struct	list	*l_next;	/* Next entry in dependency list    */
	struct	obj	*l_obj;		/* Obj structure for this entry	    */
} list_t;

/*
 * element for commands that are used to update a target
 * one allocated for each command line
 */
typedef struct cmd {
	struct	cmd	*c_next;	/* Next command for this target	    */
		char	*c_line;	/* Command line for this element    */
} cmd_t;

/*
 * element used to describe pattern rules (rules that contain a '%' sign)
 * format is:
 *	target: source	(a%b: c%d)
 *		cmdlist
 */
typedef struct patrule {
	struct	patrule	*p_next;	/* Next pattern rule		    */
	struct	cmd	*p_cmd;		/* List of commands for this rule   */
	struct	obj	*p_name;	/* Node for complete target name    */
#ifdef	xxx
	struct	obj	*p_tgt_prefix;	/*				    */
	struct	obj	*p_tgt_suffix;	/*				    */
	struct	obj	*p_src_prefix;	/*				    */
	struct	obj	*p_src_suffix;	/*				    */
#else
	char		*p_tgt_prefix;	/*				    */
	char		*p_tgt_suffix;	/*				    */
	char		*p_src_prefix;	/*				    */
	char		*p_src_suffix;	/*				    */
#endif
} patr_t;

#define	EQUAL	'='
#define	COLON	':'
#define	SEMI	';'
#define	ADDMAC	('=' | ('+'<<8))/* += */
#define	SHVAR	0x1001		/* :sh= */

#define	basetype(x)	((x) & 0xFF)

/*
 * make.c
 */
extern	void	usage		__PR((int exitcode));
extern	void	setup_dotvars	__PR((void));
extern	char*	searchtype	__PR((int mode));
extern	void	doexport	__PR((char *));
extern	int	docmd		__PR((char * cmd, obj_t * obj));
extern	BOOL	move_tgt	__PR((obj_t * from));
extern	BOOL	touch_file	__PR((char * name));
extern	date_t	gftime		__PR((char * file));
extern	long	gfileid		__PR((char * file));
extern	char*	prtime		__PR((date_t  date));

/*
 * archconf.c
 */
extern	void	setup_arch	__PR((void));

/*
 * readfile.c
 */
extern	char*	peekrdbuf	__PR((void));
extern	char*	getrdbuf	__PR((void));
extern	void	setincmd	__PR((BOOL isincmd));
extern	void	getch		__PR((void));
extern	void	skipline	__PR((void));
extern	void	readstring	__PR((char * str, char * strname));
extern	void	readfile	__PR((char * name, BOOL  must_exist));
extern	void	doinclude	__PR((char * name, BOOL  must_exist));

/*
 * parse.c
 */
extern	void	parsefile	__PR((void));
extern	void	define_var	__PR((char* name, char* val));
extern	list_t*	cvtvpath	__PR((list_t *l));
extern	obj_t*	objlook		__PR((char * name, BOOL  create));
extern	obj_t*	ssufflook	__PR((char * name, BOOL  create));
extern	BOOL	check_ssufftab	__PR((void));
extern	void	printtree	__PR((void));
#ifdef	EOF
extern	void	probj		__PR((FILE *f, obj_t * o, int type));
#endif
extern	void	prtree		__PR((void));

/*
 * update.c
 */
extern	void	initchars	__PR((void));
extern	char	*filename	__PR((char * name));
extern	BOOL	isprecious	__PR((obj_t * obj));
extern	list_t*	list_nth	__PR((list_t * list, int n));
extern	BOOL	build_path	__PR((int level, char * ename, char * path));
extern	char	*substitute	__PR((char * cmd, obj_t * obj, obj_t * source, char *suffix));
extern	char*	shout		__PR((char* cmd));
extern	BOOL	domake		__PR((char * name));
extern	BOOL	omake		__PR((obj_t * obj, BOOL  must_exist));
extern	BOOL	xmake		__PR((char * name, BOOL  must_exist));

/*
 * memory.c
 */
#ifdef	DEBUG
extern	void	prmem		__PR((void));
#endif
extern	char*	fastalloc	__PR((unsigned int size));
extern	void	fastfree	__PR((char *p, unsigned int size));
extern	void	freelist	__PR((list_t *l));
extern	char*	strsave		__PR((char *p));
extern	char*	initgbuf	__PR((int size));
extern	char*	growgbuf	__PR((char* p));


/*
 * Command line options.
 */
extern	BOOL	Sflag;		/* Do not print command lines on exec.	*/
extern	BOOL	Tflag;		/* Touch files instead of make.		*/
extern	BOOL	Qflag;		/* If up to date exit (0)		*/
extern	int	Debug;		/* Print reson for rebuild		*/
extern	int	XDebug;		/* Print extended debug info		*/
extern	int	Dmake;		/* Display makefile			*/
extern	BOOL	Prdep;		/* Print include dependendy		*/
extern	BOOL	NoWarn;		/* Don't print warning Messages.	*/
extern	BOOL	DoWarn;		/* Print extra warnings			*/
extern	char   *MakeFileNames[];/* List of pathnames of the Makefiles.	*/
extern	int	Mfilecount;	/* # of valid entries in MakeFileNames.	*/

/*
 * Various common variables.
 */
extern	BOOL	posixmode;	/* We found a .POSIX target		    */
extern	int	Mflags;
extern	char	*ObjDir;	/* .OBJDIR: pathname Target destination dir */
extern	int	ObjSearch;	/* .OBJSEARCH: searchtype for explicit rules*/
extern	list_t	*SearchList;	/* .SEARCHLIST: list of src/obj dir pairs   */
extern	list_t	*Suffixes;	/* .SUFFIXES: list of suffixes (POSIX)      */
extern	BOOL	SSuffrules;	/* Found any simple suffix rules	    */
extern	obj_t	*Init;		/* .INIT: command to execute at startup	    */
extern	obj_t	*Done;		/* .DONE: command do execute on success	    */
extern	obj_t	*Failed;	/* .FAILED: command to execute on failure   */
extern	obj_t	*IncludeFailed;	/* .INCLUDEFAILED: cmd to execute if missing*/
extern	obj_t	*Deflt;		/* .DEFAULT: command to execute if no rule  */
extern	obj_t	*Precious;	/* .PRECIOUS: list of targets not to remove */
extern	obj_t	*default_tgt;	/* Current or Default target		    */
extern	date_t	curtime;	/* current fime				    */
extern	date_t	newtime;	/* Special time newer than all	XXX	    */
extern	char	*gbuf;		/* Global growable buffer		    */
extern	char	*gbufend;	/* Current end of growable buffer	    */
extern	int	gbufsize;	/* Current size of buffer (bufend - buf)    */
extern	BOOL	found_make;	/* Did we expand the $(MAKE) macro?	    */

extern	int	lastc;		/* last input character		*/
extern	int	firstc;		/* first character in line	*/
extern	char	*mfname;	/* name of current make file	*/
extern	int	lineno;		/* current line number		*/
extern	int	col;		/* current column		*/

extern	char	Nullstr[];	/* global empty string		*/
extern	obj_t	*NullObj;	/* global empty string obj	*/
extern	char	slash[];	/* string holding path delimiter*/
#define	SLASH	PATH_DELIM

extern	patr_t	*Patrules;
extern	patr_t	**pattail;

extern	char	chartype[256];

#define	DYNCHAR	0x01
#define	NUMBER	0x02
