/* @(#)abspath.c	1.1 11/10/21 Copyright 2011 J. Schilling */
/*
 *	Compute the absolute path for a relative path name
 *
 *	Copyright (c) 2011 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#include <schily/unistd.h>
#include <schily/types.h>
#include <schily/maxpath.h>
#include <schily/string.h>
#include <schily/standard.h>
#include <schily/schily.h>
#include "at-defs.h"

EXPORT	char	*abspath	__PR((const char *relp, char *absp, size_t asize));
LOCAL	void	shorten		__PR((char *name));

/*
 * Expands a relative pathname to a full (absolute) pathname.
 */
EXPORT char *
abspath(relp, absp, asize)
		const	char	*relp;
			char	*absp;
			size_t	asize;
{
	register	char	*rel = (char *)relp; /* We do not modify relp */
	register	char	*full;

	absp[0] = '\0';
	if (relp[0] == '/') {
		if (relp[1] == '\0') {		  /* root dir		*/
			if (strlcpy(absp, relp, asize) >= asize)
				return (NULL);
			return (absp);
		}
		rel++;				  /* Strip leading slash */
		full = absp;			  /* Empty name	 */
	} else {
		full = getcwd(absp, asize);	  /* Working directory. */
		if (full == NULL)
			return (full);
	}
	for (;;) {
#ifdef	DEBUG
		printf("%s / %s\n", full, rel);
#endif
		if (strlcat(full, "/", asize) >= asize)
			return (NULL);
		if (strlcat(full, rel, asize) >= asize)
			return (NULL);
		rel = full;

		for (;;) {
			rel = strchr(++rel, '/');
			if (rel == NULL)
				break;
			if (rel[1] == '/' || rel[1] == '\0') {
				*rel++ = '\0';
							/* CSTYLED */
							/* /foo//bar = /foo/bar */
				while (rel[0] == '/')
					rel++;
				break;
			}
			if (rel[1] == '.') {
							/* /foo/./bar = /foo/bar */
				if (rel[2] == '/') {
					*rel = '\0';
					rel += 3;
					break;
				}
							/* /foo/. = /foo    */
				if (rel[2] == '\0') {
					*rel = '\0';
					rel += 2;
					break;
				}
				if (rel[2] == '.') {
							/* /foo/../bar = /bar */
					if (rel[3] == '/') {
						*rel = '\0';
						rel += 4;
						shorten(full);
						break;
					}
							/* /foo/bar/.. = /foo */
					if (rel[3] == '\0') {
						*rel = '\0';
						shorten(full);
						break;
					}
				}
			}
		}
		if (rel == NULL || rel[0] == '\0')
			break;
	}
	if (full[1] == '.' && full[2] == '\0') 			/* /. = /   */
		full[1] = '\0';
	return (full);
}

/*
 * Removes last path name component.
 */
LOCAL void
shorten(name)
	register	char	*name;
{
	register	char	*p;

	for (p = name++; *p++ != '\0'; );
	while (p > name)
		if (*--p == '/')
			break;
	*p = '\0';
}
