/*
 * $Id: read_cdda.h,v 1.6 1997/10/14 08:46:48 jim Exp $
 * Header file for read_cdda.c
 * 
 * Written by Jim Mintha (mintha@geog.ubc.ca)
 * Large portions are borrowed from the Workman 
 * sources written by Steven Grimm (koreth@hyperion.com)
 *
 * $Log: read_cdda.h,v $
 * Revision 1.6  1997/10/14 08:46:48  jim
 * clean up on exit
 *
 * Revision 1.5  1997/10/14 07:32:56  jim
 * Added specifying device
 *
 * Revision 1.4  1997/10/09 00:51:28  jim
 * return number of tracks for read_toc
 *
 * Revision 1.3  1997/09/10 00:17:34  jim
 * changed to add jitter control, clean up
 *
 * Revision 1.2  1996/01/18 14:06:25  jim
 * added get_drv_type and moved some stuff to C file
 *
 * Revision 1.1  1996/01/10 09:12:51  jim
 * Initial revision
 *
 */

/* general includes */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/fcntl.h>
#include <math.h>
#include <malloc.h>
#include <errno.h>
#include <string.h>
#include "getopt.h"
#include "gen_utils.h"

/* CDDA related includes */
#include <sys/types.h>
#include <sys/cdio.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <ustat.h>
#include <sys/scsi/impl/uscsi.h>
#include <sys/time.h>

#define SAMPLE 4
#define CDDA_BLKSIZE 2352
#define SAMPLES_PER_BLK 588
#define REREAD_BLKS 7
#define COMPARE_BLKS 3
#define SCMD_INQUIRY		0x12

enum format
{
  CDR = 0, AU8, AU16, WAV
};
 
/*
 * Information about a particular block of CDDA data.
 */

struct cdda_block {
  unsigned char	status;	
  unsigned char	track;
  unsigned char	index;
  unsigned char	minute;
  unsigned char	second;
  unsigned char	frame;
};

/* prototypes */
int cdda_init(unsigned char **, unsigned char **, long *, char *);
long cdda_read(int, unsigned char *, int, int);
long calc_jitter(unsigned char *, unsigned char *, int);
void cdda_setup(int, int, int);
void cdda_write(int, unsigned char *, long, boolean, int);
int read_toc(int, boolean);
void print_error(char *);
void usage(char *);
unsigned char linear_to_ulaw();
int convert(unsigned char *);
void write_sun_header(int, int);
void get_drv_type(int, char *);
void all_done(int);
