/*
 * $Id: libtest.c,v 1.5 1993/11/30 22:43:53 mintha Exp $
 *
 * Test out library routines
 *
 * $Log: libtest.c,v $
 * Revision 1.5  1993/11/30  22:43:53  mintha
 * Added tests to month_to_str and month_to_num and upper_case
 *
 * Revision 1.4  1993/11/23  08:20:30  mintha
 * Added test for strcmp_nc and strncmp_nc
 *
 * Revision 1.3  1993/10/20  10:30:57  mintha
 * Minor probably unnecessary change
 *
 * Revision 1.2  1993/10/20  09:55:27  mintha
 * Use new non-x include
 *
 * Revision 1.1  1993/10/05  09:53:19  mintha
 * Initial revision
 *
 */

#include <stdio.h>
#include <math.h>
#include <gen_utils.h>

NO_X_WIN

void test_str(void);
void test_num(void);
void test_date(void);
void test_misc(void);

static float swapf(float value)
{
  float rtn;
  unsigned char *p = (unsigned char *) &value;
  unsigned char *p2 = (unsigned char *) &rtn;
  
  p2[0] = p[1] - 1;
  p2[1] = p[0];
  p2[2] = p[3];
  p2[3] = p[2];
  
  return rtn;
}

int
main(int argc, char *argv[])
{
  int test;
  
  if(argc != 2)
    pop_error(ERR_GEN, "Wrong number of args: %s <num>", argv[0]);
  
  test=atoi(argv[1]);
  if(test < 1 || test > 4)
    pop_error(ERR_GEN, "Invalid test number");

  fprintf(stderr, "Testing...  Lib version: %s\n", lib_version());
  
  switch(test)
    {
    case 1:
      test_str();
      break;
    case 2:
      test_num();
      break;
    case 3:
      test_date();
      break;
    case 4:
      test_misc();
      break;
    }

  exit(0);
}

void
test_str(void)
{
  int ans1, ans2;
  char str[80], str2[80];
  
  printf("Enter strings: DONE to quit\n");
  
  while(TRUE)
    {
      gets(str);
      if(strcmp(str, "DONE") == 0)
	break;
      ans1 = conv_yesno(str, (boolean *) &ans2);
      printf("Yes or no: %d stat: %d\n", ans2, ans1);
      strip_space(str, str2, LEAD);
      printf("Stripped LEAD: |%s|\n", str2);
      strip_space(str, str2, TRAIL);
      printf("Stripped TAIL: |%s|\n", str2);
      strip_space(str, str2, LEAD | TRAIL);
      printf("Stripped BOTH: |%s|\n", str2);
      ans1 = strcmp(str, "JiMbo");
      printf("strcmp with \"JiMbo\" result = %d\n", ans1);
      ans1 = strcmp_nc(str, "JiMbo");
      printf("strcmp_nc with \"JiMbo\" result = %d\n", ans1);
      ans1 = strncmp_nc(str, "JiMbo", 3);
      printf("strncmp_nc with \"JiMbo\" and len = 3 result = %d\n", ans1);
      lower_case(str);
      printf("Lower case |%s|\n", str);
      upper_case(str);
      printf("Upper case |%s|\n", str);
    }
}
  
void
test_num(void)
{
  float val, *a, b;
  unsigned char *p = (unsigned char *) &val;
  int ctr;
  char p2[4]="abcd";
  
  p[0]=0xcb;
  p[1]=0x47;
  p[2]=0x00;
  p[3]=0x70;
  printf("Number from vax %g\n", val);
  printf("Converted: %g\n", vms_float(val));
  printf("old conversion %g\n", swapf(val));

/*  
  printf("Beginning old %s\n", time_to_char(TIME));
  for(ctr=0;ctr<2000000;ctr++)
    a=swapf(val);
  printf("Beginning new %s\n", time_to_char(TIME));
  for(ctr=0;ctr<2000000;ctr++)
    a=vms_float(val);
  printf("done %s\n", time_to_char(TIME));
  */

  val = swap_float(*((float *) p2), BYTE);
  printf("Byteswap BYTE: %.4s\n", (char *) &val);
  val = swap_float(*((float *) p2), WORD);
  printf("Byteswap WORD: %.4s\n", (char *) &val);
  val = swap_float(*((float *) p2), BYTE | WORD);
  printf("Byteswap BOTH: %.4s\n", (char *) &val);
}

void
test_misc(void)
{
  pop_error(NO_ERR, "Pop Error int %d float %f string %s",
	    (int) 5,
	    (float) 1.234,
	    "HELLO");
  set_info_level(STATUS);
  show_info(INFO, "A status to stdout line: %s\n", "With a string");
  set_info_file(stderr);
  show_info(INFO, "Another status line to stderr\n");
  show_info(STATUS, "Progess:");
  show_info(STATUS, "..");
  show_info(STATUS, "..");
  show_info(STATUS, "..");
  show_info(STATUS, "\n");
  show_info(DEBUG, "You should not see this\n");
  pop_error(ERR_OUTPUT, "Another pop error that aborts");
}

void
test_date(void)
{
  int t, t2, ans1;
  char str[256], *strptr1, *strptr2;
  
  printf("Current time VERBOSE: %s\n", time_to_char(VERBOSE));
  printf("Current time LONG: %s\n", time_to_char(LONG));
  printf("Current time DATE: %s\n", time_to_char(DATE));
  printf("Current time TIME: %s\n", time_to_char(TIME));
  
  t = time_to_hms();
  printf("Current time in integer form: %d\n", t);
  t2 = hms_to_spm(t);
  printf("Seconds past midnight %d\n", t2);
  printf("Char string with colon: %s\n", spm_to_char(t2, TRUE));
  printf("Char string without colon: %s\n", spm_to_char(t2, FALSE));
  t = spm_to_hms(t2);
  printf("Integer HHMMSS back again: %d\n", t);

  printf("Month string to number conversions: (DONE to finish)\n");
  while(TRUE)
    {
      printf("Enter month name: ");
      fflush(stdout);
      gets(str);
      if(strcmp(str, "DONE") == 0)
	break;
      ans1 = month_to_num(str);
      printf("\nMonth given: %s  Month Num: %d\n", str, ans1);
    }
  
  
  printf("Month number to string conversions: (DONE to finish)\n");
  while(TRUE)
    {
      printf("Enter month number: ");
      fflush(stdout);
      gets(str);
      if(strcmp(str, "DONE") == 0)
	break;
      strptr1 = month_to_str(atoi(str), FALSE);
      strptr2 = month_to_str(atoi(str), TRUE);
      printf("\nMonth given: %s  Month string short: %s Long: %s\n", str, strptr2, strptr1);
    }
}
