/*
 * $Id: gen_utils.h,v 1.8 1996/01/18 13:50:36 jim Exp $
 *
 * Header file for gen_utils.c
 *
 * Prototypes for generic routines
 * 
 * $Log: gen_utils.h,v $
 * Revision 1.8  1996/01/18 13:50:36  jim
 * Allow to be included multiple times
 *
 * Revision 1.7  1993/11/23 08:22:32  mintha
 * Made NO_X_WIN define to use in non X programs.
 *
 * Revision 1.6  1993/10/20  09:44:59  mintha
 * Moved most of the header into gen_utils_x.h which is now the include
 * file for x applications.  This will be the include for non-x applications
 * it defines the dummy x routines, so the linkers are happy.
 *
 * Revision 1.5  1993/10/05  09:52:05  mintha
 * Version number, new routines
 *
 * Revision 1.4  1993/09/23  09:19:26  mintha
 * Split routines into multiple source files.
 *
 * Revision 1.3  1993/09/21  10:51:31  mintha
 * added some defines, odd changes
 *
 * Revision 1.2  1993/09/13  23:20:22  mintha
 * Added strcmp_nocase
 *
 * Revision 1.1  1993/08/26  00:18:57  mintha
 * Initial revision
 *
 */

#ifndef __gen_utils_h__
#define __gen_utils_h__

#include <gen_utils_x.h>

/*
 * The follow are dummy functions that are defined when the program is not
 * an X windows application.  To use X windows include gen_utils_x.c which 
 * does not have these definitions (they are in the X libs).
 */

#ifndef NO_X_WIN
#define NO_X_WIN \
\
boolean interactive = FALSE; \
void *panel;\
void finish(int status){ exit(status); } \
void notice_prompt(void *d, int d1, int d2, void *d3, int d4, int d5, void *d6, int d7){} \
void notify_dispatch(void){ } \

#endif /* NO_X_WIN */
#endif /* __gen_utils_h__ */
