/*
 * $Id: read_cdda.h,v 1.2 1996/01/18 14:06:25 jim Exp $
 * Header file for read_cdda.c
 * 
 * Written by Jim Mintha (mintha@geog.ubc.ca)
 * Large portions are borrowed from the Workman 
 * sources written by Steven Grimm (koreth@hyperion.com)
 *
 * $Log: read_cdda.h,v $
 * Revision 1.2  1996/01/18 14:06:25  jim
 * added get_drv_type and moved some stuff to C file
 *
 * Revision 1.1  1996/01/10 09:12:51  jim
 * Initial revision
 *
 */

/* general includes */
#include <stdio.h>
#include <sys/fcntl.h>
#include <math.h>
#include <malloc.h>
#include <errno.h>
#include "getopt.h"
#include "gen_utils.h"

/* CDDA related includes */
#include <sys/types.h>
#include <sys/cdio.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <ustat.h>
#include <sys/scsi/impl/uscsi.h>
#include <sys/time.h>

#define CDDABLKSIZE 2368
#define SAMPLES_PER_BLK 588
#define SCMD_INQUIRY		0x12

enum status
{
  WMCDDA_ERROR = 0,	/* Couldn't read CDDA from disc */
  WMCDDA_OK,		/* Read this block successfully (raw data) */
  WMCDDA_PLAYED,	/* Just played the block in question */
  WMCDDA_STOPPED,	/* Block data invalid; we've just stopped */
  WMCDDA_ACK,		/* Acknowledgement of command from parent */
  WMCDDA_DONE,		/* Chunk of data is done playing */
  WMCDDA_EJECTED      	/* Disc ejected or offline */
};

enum format
{
  CDR = 0, AU8, AU16
};
 
/*
 * Information about a particular block of CDDA data.
 */

struct cdda_block {
  unsigned char	status;	
  unsigned char	track;
  unsigned char	index;
  unsigned char	minute;
  unsigned char	second;
  unsigned char	frame;
};

/* prototypes */
int cdda_init(char **, long *);
long cdda_read(int, unsigned char *, long, struct cdda_block *);
void cdda_setup(int, int, int);
void cdda_write(int, unsigned char *, long, boolean, int);
void read_toc(int, int, boolean);
void print_error(char *);
void usage(char *);
unsigned char linear_to_ulaw();
int convert(unsigned char *);
void write_sun_header(int, int);
void get_drv_type(int);
