/*
 * $Id: drv_type.c,v 1.2 1996/01/18 14:21:39 jim Exp $
 * Get CDROM drive type
 *
 * $Log: drv_type.c,v $
 * Revision 1.2  1996/01/18 14:21:39  jim
 * Fixing a casting warning
 *
 * Revision 1.1  1996/01/18 14:06:37  jim
 * Initial revision
 *
 */

#include "read_cdda.h"

/* 
 * send command to CD-ROM to read model and vendor.
 */

void
get_drv_type(int fd)
{
  struct uscsi_cmd cmd;
  unsigned char cdb[12];
  unsigned char buf[36];
  char vendor[STR_LEN], model[STR_LEN], rev[STR_LEN];
    
  /* open the device */
  fd = open("/dev/rdsk/c0t6d0s2", 0);
  if(fd < 0)
    pop_error(ERR_FILE, "Open of CD-ROM device failed");

  cdb[0] = SCMD_INQUIRY;
  cdb[1] = 0;
  cdb[2] = 0;
  cdb[3] = 0;
  cdb[4] = 36;
  cdb[5] = 0;
  
  memset(&cmd, 0, sizeof(cmd));
  cmd.uscsi_cdb = (void *) &cdb;
  cmd.uscsi_cdblen = 6;
  cmd.uscsi_bufaddr = (void *) &buf;
  cmd.uscsi_buflen = 36;
  cmd.uscsi_flags = USCSI_ISOLATE | USCSI_SILENT | USCSI_READ;

  if(ioctl(fd, USCSICMD, &cmd))
    pop_error(ERR_GEN, "Error getting drive type");
  
  if(cmd.uscsi_status)
    pop_error(ERR_GEN, "Getting drive type returned error");
  
  memcpy(vendor, buf + 8, 8);
  vendor[8] = '\0';
  memcpy(model, buf + 16, 16);
  model[16] = '\0';
  memcpy(rev, buf + 32, 4);
  rev[4] = '\0';
  
  /* print out the info */

  printf("Vendor: %s\n", vendor);
  printf(" Model: %s\n", model);
  printf("  rev.: %s\n", rev);
}

 
