/* Getopt for GNU.
   Copyright (C) 1987, 88, 89, 90, 91, 1992 Free Software Foundation, Inc.

   $Id: getopt1.c,v 1.1 1993/09/23 09:22:49 mintha Exp $
   $Log: getopt1.c,v $
 * Revision 1.1  1993/09/23  09:22:49  mintha
 * Initial revision
 *

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef	LIBC
/* For when compiled as part of the GNU C library.  */
#include <ansidecl.h>
#endif

#include "getopt.h"

#ifndef __STDC__
#define const
#endif

#if defined(STDC_HEADERS) || defined(__GNU_LIBRARY__) || defined (LIBC)
#include <stdlib.h>
#else /* STDC_HEADERS or __GNU_LIBRARY__ */
char *getenv ();
#endif /* STDC_HEADERS or __GNU_LIBRARY__ */

#if !defined (NULL)
#define NULL 0
#endif

int
getopt_long (argc, argv, options, long_options, opt_index)
     int argc;
     char *const *argv;
     const char *options;
     const struct option *long_options;
     int *opt_index;
{
  return _getopt_internal (argc, argv, options, long_options, opt_index, 0);
}

/* Like getopt_long, but '-' as well as '--' can indicate a long option.
   If an option that starts with '-' (not '--') doesn't match a long option,
   but does match a short option, it is parsed as a short option
   instead.  */

int 
getopt_long_only (argc, argv, options, long_options, opt_index)
     int argc;
     char *const *argv;
     const char *options;
     const struct option *long_options;
     int *opt_index;
{
  return _getopt_internal (argc, argv, options, long_options, opt_index, 1);
}
