/*
 * $Id: gen_utils_x.h,v 1.8 1996/01/18 13:50:56 jim Exp $
 *
 * Header file for gen_utils.c
 *
 * Prototypes for generic routines
 * 
 * $Log: gen_utils_x.h,v $
 * Revision 1.8  1996/01/18 13:50:56  jim
 * allow to be included multiple times
 *
 * Revision 1.7  1994/11/11 12:05:08  mintha
 * define TRUE/FALSE if needed, added function to get info level
 * increased LONG_STR and HUGE_STR
 *
 * Revision 1.6  1994/02/06  23:51:12  mintha
 * Cleaned up this version a bit
 *
 * Revision 1.5  1993/11/30  22:44:23  mintha
 * Added month_to_str and month_to_num & upper_case
 *
 * Revision 1.4  1993/11/23  08:20:11  mintha
 * Added strcmp_nc
 *
 * Revision 1.3  1993/10/27  09:44:14  mintha
 * Increase version number
 *
 * Revision 1.2  1993/10/27  09:43:00  mintha
 * Increased debugging levels 0-10 now
 *
 * Revision 1.1  1993/10/20  09:42:58  mintha
 * Initial revision
 *
 * Revision 1.5  1993/10/05  09:52:05  mintha
 * Version number, new routines
 *
 * Revision 1.4  1993/09/23  09:19:26  mintha
 * Split routines into multiple source files.
 *
 * Revision 1.3  1993/09/21  10:51:31  mintha
 * added some defines, odd changes
 *
 * Revision 1.2  1993/09/13  23:20:22  mintha
 * Added strcmp_nocase
 *
 * Revision 1.1  1993/08/26  00:18:57  mintha
 * Initial revision
 *
 */

#ifndef __gen_utils_x_h__
#define __gen_utils_x_h__

/*
 * Standard defines
 */

#define STR_LEN 80
#define LONG_STR 1024
#define HUGE_STR 4096
#define FNAME_LEN 255
#define LIBJIM_VERSION "1.10"

#ifdef FALSE
#undef FALSE
#endif

#ifdef TRUE
#undef TRUE
#endif

enum bool 
{
  FALSE = 0, TRUE = 1
};

typedef enum bool boolean;

enum errors
{
  NO_ERR = 0,
  ERR_MALLOC = 2, ERR_FREE,
  ERR_HDF, ERR_OUTPUT,
  ERR_M2, ERR_FILE, 
  ERR_GEN, ERR_CDF,
  ERR_INPUT
};

enum strip
{
  LEAD = 1,
  TRAIL
};

enum byteconv
{
  BYTE = 1,
  WORD
};

enum date
{
  VERBOSE = 1,
  LONG, DATE, TIME
};

enum info
{                  /* description */            /* sample output */
  NONE = 0,    /* no info printed       */
  NONEX,       /* very basic info       */ /* start, processing, end       */
  INFO,        /* just important info   */ /* + preprocess, file1, file2   */
  INFOX,       /* important plus        */ /* + rew. tape, creating (slow) */
  STATUS,      /* current status        */ /* + rec # (by 20's), position  */ 
  STATUSX,     /* detailed status       */ /* + rec # (by 5/1s)            */
  DEBUG,       /* debugging info        */ /* open, close, option proc'ing */
  DEBUGX,      /* lots of debugging     */ /* return status, calc'd vals   */
  DETAIL,      /* lots & lots of info   */ /* variable values, enter procs */
  DETAILX,     /* tonnes of info        */ /* vars in loops, structures    */
  OVERKILL     /* more info than needed */ /* anything else                */
};

/*
 * gen_str.c - string functions
 */

int strncmp_nc(char *, char *, int);     /* case insensitive compare strings */
int strcmp_nc(char *, char *);           /* case insensitive compare strings */
void lower_case(char *);                 /* lower case a string              */
void upper_case(char *);                 /* upper case a string              */
boolean conv_yesno(char *, boolean *);   /* convert yes/no string to T/F     */
void strip_space(char *, char *, int);   /* Strip space from beg/end of str  */

/*
 * gen_date.c - Date functions
 */

int spm_to_hms(int);                     /* seconds past midnight to HHMMSS  */
int hms_to_spm(int);                     /* HHMMSS to seconds past midnight  */
char *spm_to_char(int, boolean);         /* seconds past midnight to string  */
char *hms_to_char(int, boolean);         /* integer HHMMSS to string         */
char *time_to_char(int);                 /* Current time/date to string      */
int time_to_hms(void);                   /* current time to HHMMSS           */
int month_to_num(char *);                /* convert month string to numeric  */
char *month_to_str(int, boolean);        /* convert month number to string   */

/*
 * gen_num.c - Numeric functions
 */

unsigned int swap_int(unsigned int, int); /* swap bytes/words in integers    */
float swap_float(float, int);            /* swap bytes/words in floats       */  
float vms_float(float);                  /* convert vms float to ieee style  */

/*
 * gen_misc.c - Miscellaneous functions
 */

void pop_error(int, char *, ...);        /* Output an error message          */
void show_info(int, char *, ...);        /* output status info               */
void set_info_file(FILE *);              /* set the destination for info     */
void set_info_level(int);                /* set the level for info messages  */
int get_info_level(void);                /* get the current info level       */
void *chk_malloc(unsigned int);          /* allocate some memory, validate   */
void chk_free(void *);                   /* free a block of memory if valid  */
void chk_cdf(int, char *);               /* check status of CDF routine      */
void chk_hdf(int, char *);               /* check status of HDF routine      */
boolean chk_read(int, char *, int);      /* Check if a block read successful */
boolean chk_write(int, char *, int);     /* Check if a block write sucessful */
void chk_rtn(int, int, char *);          /* check the return value of func.  */
char *lib_version(void);                 /* return string with lib version   */

#endif /* __gen_utils_x_h__ */
