/* FRV ELF support for BFD.
   Copyright (C) 1998, 1999 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _ELF_FRV_H
#define _ELF_FRV_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_frv_reloc_type)
  RELOC_NUMBER (R_FRV_NONE, 0)
  RELOC_NUMBER (R_FRV_8, 1)
  RELOC_NUMBER (R_FRV_16, 2)
  RELOC_NUMBER (R_FRV_32, 3)
  RELOC_NUMBER (R_FRV_LABEL16, 4)
  RELOC_NUMBER (R_FRV_LABEL24, 5)
  RELOC_NUMBER (R_FRV_LO16, 6)
  RELOC_NUMBER (R_FRV_HI16, 7)
  RELOC_NUMBER (R_FRV_SDA, 8)
  RELOC_NUMBER (R_FRV_LO_PC16, 9)
  RELOC_NUMBER (R_FRV_HI_PC16, 10)
  RELOC_NUMBER (R_FRV_GNU_VTINHERIT, 11)
  RELOC_NUMBER (R_FRV_GNU_VTENTRY, 12)
  EMPTY_RELOC  (R_FRV_max)
END_RELOC_NUMBERS

/* Processor specific flags for the ELF header e_flags field.  */
						/* gpr support */
#define EF_FRV_GPR_MASK		0x00000003	/* mask for # of gprs */
#define EF_FRV_GPR_32		0x00000001	/* -mgpr-32 */
#define EF_FRV_GPR_64		0x00000002	/* -mgpr-64 */

						/* fpr support */
#define EF_FRV_FPR_MASK		0x0000000c	/* mask for # of fprs */
#define EF_FRV_FPR_32		0x00000004	/* -mfpr-32 */
#define EF_FRV_FPR_64		0x00000008	/* -mfpr-64 */
#define EF_FRV_FPR_NONE		0x0000000c	/* -msoft-float */

						/* double word support */
#define EF_FRV_DWORD_MASK	0x00000030	/* mask for dword support */
#define EF_FRV_DWORD_YES	0x00000010	/* use double word insns */
#define EF_FRV_DWORD_NO		0x00000020	/* don't use double word insn*/

#define EF_FRV_DOUBLE		0x00000040	/* -mdouble */
#define EF_FRV_MEDIA		0x00000080	/* -mmedia */

						/* Mask of all flags */
#define EF_FRV_ALL_FLAGS	(EF_FRV_GPR_MASK | \
				 EF_FRV_FPR_MASK | \
				 EF_FRV_DWORD_MASK | \
				 EF_FRV_DOUBLE | \
				 EF_FRV_MEDIA)
#endif /* _ELF_FRV_H */
