/* resampling module 
 *
 * The audio data has been read. Here are the
 * functions to ensure a correct continuation
 * of the output stream and to convert to a
 * lower sample rate.
 *
 */

#define SYNC_OFF	150L
#undef    DEBUG_SHIFTS		/* simulate bad cdrom drives */
#undef SHOW_JITTER

#include <stdio.h>
#include <stdlib.h>
#if defined (HAVE_UNISTD_H) && (HAVE_UNISTD_H == 1)
#include <sys/types.h>
#include <unistd.h>
#endif
#include <stddef.h>
#include <string.h>
#include <limits.h>
#include <assert.h>

#include "mycdrom.h"
#include "read2448.h"
#include "interface.h"
#include "byteorder.h"
#include "ringbuff.h"
#include "resample.h"
#include "global.h"



static unsigned char *pStart;	/* running ptr defining end of output buffer */
static unsigned char *pDst;	/* start of output buffer */

long 
SaveBuffer (unsigned char *p,
	    unsigned long SamplesToDo, 
	    unsigned long *TotSamplesDone)
{
  pDst = p + SamplesToDo*4;
  pStart = p;

  /* code for output stage */
  if ( 1) {
    int retval = 0;
    unsigned outlen;

    assert(pDst >= pStart);
    outlen = (size_t) (pDst - pStart);

    if (outlen <= 0) return 0;

    if ( global.no_file != 0 ) {
        return 0;
    }
    if ((unsigned)(retval = write ( global.audio, pStart, outlen )) == outlen) {
	return 0;
    } else {
        fprintf(stderr, "write(audio, 0x%p, %u) = %d\n",pStart,outlen,retval);
        perror("Probably disk space exhausted");
        return 1;
    }
  } else return 0;
}


