/***
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) by Heiko Eissfeldt
 *
 * header file interface.h for cdda2wav */

#include "mytype.h"

#ifndef CD_FRAMESIZE
#define CD_FRAMESIZE 2048
#endif

#ifndef CD_FRAMESIZE_RAW
#define CD_FRAMESIZE_RAW 2352
#endif

/* this includes 2352 data bytes + 96 subchannel bytes (P-W) */
#undef CD_FRAMESIZE_RAWER
#define CD_FRAMESIZE_RAWER 2448

/* this includes 2352 data bytes
                + 296 c2 and block error flag bytes
                +  96 subchannel bytes (P-W) */
#undef CD_FRAMESIZE_RAWEST
#define CD_FRAMESIZE_RAWEST 2744

#define CD_FRAMESAMPLES (CD_FRAMESIZE_RAW / 4)
#define CD_FRAMEQBYTES (CD_FRAMESIZE_RAWER - CD_FRAMESIZE_RAW)
#define CD_FRAMEEBYTES (CD_FRAMESIZE_RAWEST - CD_FRAMESIZE_RAW - CD_FRAMEQBYTES)

#define MAXTRK	100	/* maximum of audio tracks */

typedef struct TOC {	/* structure of table of contents (cdrom) */
  unsigned char reserved1;
  unsigned char bFlags;
  unsigned char bTrack;
  unsigned char reserved2;
  unsigned int dwStartSector;
  unsigned char ISRC[15];
} TOC;

extern TOC g_toc [MAXTRK]; /* 100 */
extern unsigned char MCN[15];

#define IS_AUDIO(i) (!(g_toc[i].bFlags & 0x04))

extern unsigned interface;
extern unsigned char *bufferCdda;
extern unsigned cd_framesize;

#define NSECTORS 75

/* interface types */
#define GENERIC_SCSI	0

/* cdrom access function pointer */
extern unsigned (*ReadToc) ( TOC *ptoc );
extern void     (*ReadCdRom) (unsigned char *p, long lSector, unsigned long SectorBurstVal, int with_errorblockflags );
extern void     (*SelectSpeed) ( unsigned speed );

void SetupInterface( unsigned framesize );
