/* index scanner first version
   caution: some drive deliver verbatim bcd values like plextor.
   Do mmc-3 drives really assemble/convert-to-bin/serialize ???
   Cannot believe this. */

#include <stdio.h>

#define CD_FRAMESIZE_RAW 2352
#define SUBSIZE 96

union u {
 unsigned char b[SUBSIZE/8];
 struct q {
   unsigned char ctrl_adr;
   unsigned char track;
   unsigned char index;
   unsigned char min;
   unsigned char sec;
   unsigned char frame;
   unsigned char zero;
   unsigned char amin;
   unsigned char asec;
   unsigned char aframe;
   unsigned char crc1;    /* all bits inverted. Polynom is */
   unsigned char crc2;    /* X^16 + X^12 + X^5 + 1 */
/*
   unsigned char pad[3];
   unsigned char Psub;
*/
 } q;
};

union u u;


/* +++Date last modified: 05-Jul-1997 */


/*
 * Calculate, intelligently, the CRC of a dataset incrementally given a
 * buffer full at a time.
 * Initialize crc to 0.
 *
 * Usage:
 *   newcrc = updcrc( oldcrc, bufadr, buflen )
 *        size_t oldcrc, buflen;
 *        char *bufadr;
 *
 */

#include <stdlib.h>           /* For size_t                 */
#if !defined(WIN32) && !defined(_WIN32) && !defined(__NT__) \
      && !defined(_WINDOWS)
 #if !defined(OS2)
  typedef unsigned char  BYTE;
  typedef unsigned int  DWORD;
 #endif
 typedef unsigned short WORD;
#else
 #define WIN32_LEAN_AND_MEAN
 #define NOGDI
 #define NOSERVICE
 #undef INC_OLE1
 #undef INC_OLE2
 #include <windows.h>
 #define HUGE
#endif

/* TODO: rename P, W, B */
#define   P    0x1021

    /* number of bits in CRC: don't change it. */
#define W 16

    /* this the number of bits per char: don't change it. */
#define B 8

static WORD crctab[1<<B] = { /* as calculated by initcrctab() */
    0x0000,  0x1021,  0x2042,  0x3063,  0x4084,  0x50a5,  0x60c6,  0x70e7,
    0x8108,  0x9129,  0xa14a,  0xb16b,  0xc18c,  0xd1ad,  0xe1ce,  0xf1ef,
    0x1231,  0x0210,  0x3273,  0x2252,  0x52b5,  0x4294,  0x72f7,  0x62d6,
    0x9339,  0x8318,  0xb37b,  0xa35a,  0xd3bd,  0xc39c,  0xf3ff,  0xe3de,
    0x2462,  0x3443,  0x0420,  0x1401,  0x64e6,  0x74c7,  0x44a4,  0x5485,
    0xa56a,  0xb54b,  0x8528,  0x9509,  0xe5ee,  0xf5cf,  0xc5ac,  0xd58d,
    0x3653,  0x2672,  0x1611,  0x0630,  0x76d7,  0x66f6,  0x5695,  0x46b4,
    0xb75b,  0xa77a,  0x9719,  0x8738,  0xf7df,  0xe7fe,  0xd79d,  0xc7bc,
    0x48c4,  0x58e5,  0x6886,  0x78a7,  0x0840,  0x1861,  0x2802,  0x3823,
    0xc9cc,  0xd9ed,  0xe98e,  0xf9af,  0x8948,  0x9969,  0xa90a,  0xb92b,
    0x5af5,  0x4ad4,  0x7ab7,  0x6a96,  0x1a71,  0x0a50,  0x3a33,  0x2a12,
    0xdbfd,  0xcbdc,  0xfbbf,  0xeb9e,  0x9b79,  0x8b58,  0xbb3b,  0xab1a,
    0x6ca6,  0x7c87,  0x4ce4,  0x5cc5,  0x2c22,  0x3c03,  0x0c60,  0x1c41,
    0xedae,  0xfd8f,  0xcdec,  0xddcd,  0xad2a,  0xbd0b,  0x8d68,  0x9d49,
    0x7e97,  0x6eb6,  0x5ed5,  0x4ef4,  0x3e13,  0x2e32,  0x1e51,  0x0e70,
    0xff9f,  0xefbe,  0xdfdd,  0xcffc,  0xbf1b,  0xaf3a,  0x9f59,  0x8f78,
    0x9188,  0x81a9,  0xb1ca,  0xa1eb,  0xd10c,  0xc12d,  0xf14e,  0xe16f,
    0x1080,  0x00a1,  0x30c2,  0x20e3,  0x5004,  0x4025,  0x7046,  0x6067,
    0x83b9,  0x9398,  0xa3fb,  0xb3da,  0xc33d,  0xd31c,  0xe37f,  0xf35e,
    0x02b1,  0x1290,  0x22f3,  0x32d2,  0x4235,  0x5214,  0x6277,  0x7256,
    0xb5ea,  0xa5cb,  0x95a8,  0x8589,  0xf56e,  0xe54f,  0xd52c,  0xc50d,
    0x34e2,  0x24c3,  0x14a0,  0x0481,  0x7466,  0x6447,  0x5424,  0x4405,
    0xa7db,  0xb7fa,  0x8799,  0x97b8,  0xe75f,  0xf77e,  0xc71d,  0xd73c,
    0x26d3,  0x36f2,  0x0691,  0x16b0,  0x6657,  0x7676,  0x4615,  0x5634,
    0xd94c,  0xc96d,  0xf90e,  0xe92f,  0x99c8,  0x89e9,  0xb98a,  0xa9ab,
    0x5844,  0x4865,  0x7806,  0x6827,  0x18c0,  0x08e1,  0x3882,  0x28a3,
    0xcb7d,  0xdb5c,  0xeb3f,  0xfb1e,  0x8bf9,  0x9bd8,  0xabbb,  0xbb9a,
    0x4a75,  0x5a54,  0x6a37,  0x7a16,  0x0af1,  0x1ad0,  0x2ab3,  0x3a92,
    0xfd2e,  0xed0f,  0xdd6c,  0xcd4d,  0xbdaa,  0xad8b,  0x9de8,  0x8dc9,
    0x7c26,  0x6c07,  0x5c64,  0x4c45,  0x3ca2,  0x2c83,  0x1ce0,  0x0cc1,
    0xef1f,  0xff3e,  0xcf5d,  0xdf7c,  0xaf9b,  0xbfba,  0x8fd9,  0x9ff8,
    0x6e17,  0x7e36,  0x4e55,  0x5e74,  0x2e93,  0x3eb2,  0x0ed1,  0x1ef0,
    };

WORD updcrc(register WORD    crc,
            register BYTE   *cp,
            register size_t  cnt)
{
      while( cnt-- )
#ifdef SLOWERCRC
            crc = (crc<<B) ^ crctab[(crc>>(W-B)) ^ ~(*cp++)];
#else
            crc = (crc<<B) ^ crctab[(crc>>(W-B)) ^ (*cp++)];
#endif
      return( crc );
}

WORD calcCRC(unsigned char *buf, unsigned bsize)
{
#ifdef SLOWERCRC
      return updcrc( 0xffff, (BYTE *)buf, bsize );
#else
      return updcrc( 0xffff, (BYTE *)buf, bsize ) ^ 0x99f6;
#endif
}

char	fliptab[8] = {
	0x01,
	0x02,
	0x04,
	0x08,
	0x10,
	0x20,
	0x40,
	0x80,
};

int flip_error_corr(unsigned char *b, int crc)
{
  if (crc != 0) {
    int i;
    for (i = 0; i < SUBSIZE; i++) {
      char	c;

      c = fliptab[i%8];
      u.b[i / 8] ^= c;
      if ((crc = calcCRC(u.b, SUBSIZE/8)) == 0) {
        return crc;
      }
      u.b[i / 8] ^= c;
    }
  }
  return crc;
}

/* collect bytes from bit-channels */
int getQ(unsigned char subs[])
{
  int crc;
  int i;

#if 0
  for (i = 0; i < SUBSIZE; i++) {
#if 1
    u.b[i / 8] = (u.b[i / 8] << 1) | ((subs[i] >> 6) & 1);
#else
    u.b[i / 8] <<= 1;
    u.b[i / 8] |= (subs[i] >> 6) & 1;
#endif
  }
#else
    u.b[00] = (((subs[00 + 0] & 0x40) >> 0) << 1) |
              (((subs[00 + 1] & 0x40) >> 0) << 0) |
              (((subs[00 + 2] & 0x40) >> 1) << 0) |
              (((subs[00 + 3] & 0x40) >> 2) << 0) |
              (((subs[00 + 4] & 0x40) >> 3) << 0) |
              (((subs[00 + 5] & 0x40) >> 4) << 0) |
              (((subs[00 + 6] & 0x40) >> 5) << 0) |
              (((subs[00 + 7] & 0x40) >> 6) << 0);
    u.b[01] = (((subs[ 8 + 0] & 0x40) >> 0) << 1) |
              (((subs[ 8 + 1] & 0x40) >> 0) << 0) |
              (((subs[ 8 + 2] & 0x40) >> 1) << 0) |
              (((subs[ 8 + 3] & 0x40) >> 2) << 0) |
              (((subs[ 8 + 4] & 0x40) >> 3) << 0) |
              (((subs[ 8 + 5] & 0x40) >> 4) << 0) |
              (((subs[ 8 + 6] & 0x40) >> 5) << 0) |
              (((subs[ 8 + 7] & 0x40) >> 6) << 0);
    u.b[02] = (((subs[16 + 0] & 0x40) >> 0) << 1) |
              (((subs[16 + 1] & 0x40) >> 0) << 0) |
              (((subs[16 + 2] & 0x40) >> 1) << 0) |
              (((subs[16 + 3] & 0x40) >> 2) << 0) |
              (((subs[16 + 4] & 0x40) >> 3) << 0) |
              (((subs[16 + 5] & 0x40) >> 4) << 0) |
              (((subs[16 + 6] & 0x40) >> 5) << 0) |
              (((subs[16 + 7] & 0x40) >> 6) << 0);
    u.b[03] = (((subs[24 + 0] & 0x40) >> 0) << 1) |
              (((subs[24 + 1] & 0x40) >> 0) << 0) |
              (((subs[24 + 2] & 0x40) >> 1) << 0) |
              (((subs[24 + 3] & 0x40) >> 2) << 0) |
              (((subs[24 + 4] & 0x40) >> 3) << 0) |
              (((subs[24 + 5] & 0x40) >> 4) << 0) |
              (((subs[24 + 6] & 0x40) >> 5) << 0) |
              (((subs[24 + 7] & 0x40) >> 6) << 0);
    u.b[04] = (((subs[32 + 0] & 0x40) >> 0) << 1) |
              (((subs[32 + 1] & 0x40) >> 0) << 0) |
              (((subs[32 + 2] & 0x40) >> 1) << 0) |
              (((subs[32 + 3] & 0x40) >> 2) << 0) |
              (((subs[32 + 4] & 0x40) >> 3) << 0) |
              (((subs[32 + 5] & 0x40) >> 4) << 0) |
              (((subs[32 + 6] & 0x40) >> 5) << 0) |
              (((subs[32 + 7] & 0x40) >> 6) << 0);
    u.b[05] = (((subs[40 + 0] & 0x40) >> 0) << 1) |
              (((subs[40 + 1] & 0x40) >> 0) << 0) |
              (((subs[40 + 2] & 0x40) >> 1) << 0) |
              (((subs[40 + 3] & 0x40) >> 2) << 0) |
              (((subs[40 + 4] & 0x40) >> 3) << 0) |
              (((subs[40 + 5] & 0x40) >> 4) << 0) |
              (((subs[40 + 6] & 0x40) >> 5) << 0) |
              (((subs[40 + 7] & 0x40) >> 6) << 0);
    u.b[06] = (((subs[48 + 0] & 0x40) >> 0) << 1) |
              (((subs[48 + 1] & 0x40) >> 0) << 0) |
              (((subs[48 + 2] & 0x40) >> 1) << 0) |
              (((subs[48 + 3] & 0x40) >> 2) << 0) |
              (((subs[48 + 4] & 0x40) >> 3) << 0) |
              (((subs[48 + 5] & 0x40) >> 4) << 0) |
              (((subs[48 + 6] & 0x40) >> 5) << 0) |
              (((subs[48 + 7] & 0x40) >> 6) << 0);
    u.b[07] = (((subs[56 + 0] & 0x40) >> 0) << 1) |
              (((subs[56 + 1] & 0x40) >> 0) << 0) |
              (((subs[56 + 2] & 0x40) >> 1) << 0) |
              (((subs[56 + 3] & 0x40) >> 2) << 0) |
              (((subs[56 + 4] & 0x40) >> 3) << 0) |
              (((subs[56 + 5] & 0x40) >> 4) << 0) |
              (((subs[56 + 6] & 0x40) >> 5) << 0) |
              (((subs[56 + 7] & 0x40) >> 6) << 0);
    u.b[ 8] = (((subs[64 + 0] & 0x40) >> 0) << 1) |
              (((subs[64 + 1] & 0x40) >> 0) << 0) |
              (((subs[64 + 2] & 0x40) >> 1) << 0) |
              (((subs[64 + 3] & 0x40) >> 2) << 0) |
              (((subs[64 + 4] & 0x40) >> 3) << 0) |
              (((subs[64 + 5] & 0x40) >> 4) << 0) |
              (((subs[64 + 6] & 0x40) >> 5) << 0) |
              (((subs[64 + 7] & 0x40) >> 6) << 0);
    u.b[ 9] = (((subs[72 + 0] & 0x40) >> 0) << 1) |
              (((subs[72 + 1] & 0x40) >> 0) << 0) |
              (((subs[72 + 2] & 0x40) >> 1) << 0) |
              (((subs[72 + 3] & 0x40) >> 2) << 0) |
              (((subs[72 + 4] & 0x40) >> 3) << 0) |
              (((subs[72 + 5] & 0x40) >> 4) << 0) |
              (((subs[72 + 6] & 0x40) >> 5) << 0) |
              (((subs[72 + 7] & 0x40) >> 6) << 0);
    u.b[10] = (((subs[80 + 0] & 0x40) >> 0) << 1) |
              (((subs[80 + 1] & 0x40) >> 0) << 0) |
              (((subs[80 + 2] & 0x40) >> 1) << 0) |
              (((subs[80 + 3] & 0x40) >> 2) << 0) |
              (((subs[80 + 4] & 0x40) >> 3) << 0) |
              (((subs[80 + 5] & 0x40) >> 4) << 0) |
              (((subs[80 + 6] & 0x40) >> 5) << 0) |
              (((subs[80 + 7] & 0x40) >> 6) << 0);
    u.b[11] = (((subs[88 + 0] & 0x40) >> 0) << 1) |
              (((subs[88 + 1] & 0x40) >> 0) << 0) |
              (((subs[88 + 2] & 0x40) >> 1) << 0) |
              (((subs[88 + 3] & 0x40) >> 2) << 0) |
              (((subs[88 + 4] & 0x40) >> 3) << 0) |
              (((subs[88 + 5] & 0x40) >> 4) << 0) |
              (((subs[88 + 6] & 0x40) >> 5) << 0) |
              (((subs[88 + 7] & 0x40) >> 6) << 0);
#endif

  /* calculate CRC checksum */
  crc =  calcCRC(u.b, SUBSIZE/8);

  crc = flip_error_corr(u.b, crc);

  return crc;
}

void bcd2bin(unsigned char *p)
{
  *p = (*p>>4)*10+(*p&0x0F);
}

unsigned char bin2bcd(unsigned p)
{
  return ((p/10)<<4)|(p%10);
}

static int crc_errors;

#define DEBUG_HEUR 1
int correct_heuristically(union u u2, unsigned char tr, unsigned char in,
                          unsigned last_asec, unsigned last_rsec, unsigned crcres)
{
  int result = 0;
  int newtrack;
  int transitionindex1;

  bcd2bin(&u2.q.track);
  bcd2bin(&u2.q.index);
  bcd2bin(&u2.q.min);
  bcd2bin(&u2.q.sec);
  bcd2bin(&u2.q.frame);
  bcd2bin(&u2.q.amin);
  bcd2bin(&u2.q.asec);
  bcd2bin(&u2.q.aframe);

if (DEBUG_HEUR) fprintf(stdout, "am %d:%2d.%02d, rm %d:%2d.%02d, tr %d, in %d, "
"ctl_adr %x, zero %x, crc1 %02x, crc2 %02x, las %u, lrs %u, ltr %d, lin %d\n",
  u2.q.amin, u2.q.asec, u2.q.aframe,
  u2.q.min, u2.q.sec, u2.q.frame,
  u2.q.track, u2.q.index,
  u2.q.ctrl_adr, u2.q.zero, u2.q.crc1, u2.q.crc2,
  last_asec, last_rsec,
  tr, in);

  /* check absolute position */
  if (u2.q.aframe > 74U ||
      u2.q.amin > 59U ||
      u2.q.asec > 59U ||
      u2.q.aframe + (75*u2.q.asec) + (75*60*u2.q.amin) - 150 - 1 != (signed)last_asec) {
    /* absolute position is dubious */
    if (u2.q.aframe != (last_asec + 151) % 75) {
      u2.q.aframe = ((last_asec + 151) % 75);
      u.q.aframe = bin2bcd(u2.q.aframe);
if (DEBUG_HEUR) fprintf(stdout, "corrected aframe to %x\n", u.q.aframe);
      result = 1;
    }
    if (u2.q.asec != ((last_asec + 151) / 75) % 60) {
      u2.q.asec = (((last_asec + 151) / 75) % 60);
      u.q.asec = bin2bcd(u2.q.asec);
if (DEBUG_HEUR) fprintf(stdout, "corrected asec to %x\n", u.q.asec);
      result = 1;
    }
    if (u2.q.amin != ((last_asec + 151) / 75) / 60) {
      u2.q.amin = (((last_asec + 151) / 75) / 60);
      u.q.amin = bin2bcd(u2.q.amin);
if (DEBUG_HEUR) fprintf(stdout, "corrected amin to %x\n", u.q.amin);
      result = 1;
    }
  }

  newtrack = 0;
  if ((u2.q.track == tr + 1 && u2.q.index == 0) ||
      (u2.q.track == tr + 1 && (u2.q.index == 1 || !(u2.q.frame || u2.q.sec || u2.q.min)))
     ) {
    newtrack = 1;
  }
  /* check track */
  if (u2.q.track > 99U ||
      (!newtrack && u2.q.track != tr) ||
      (newtrack && u2.q.track != tr + 1)) {
      u2.q.track = newtrack ? tr + 1 : tr;
      u.q.track = bin2bcd(u2.q.track);
if (DEBUG_HEUR) fprintf(stdout, "corrected track to %x\n", u.q.track);
      result = 1;
  }
  if (u2.q.track == tr + 1 && u2.q.index == 0) {
    newtrack = 1;
  }
  /* check index */
  if (u2.q.index > 99U ||
      (!newtrack && (u2.q.index != in && u2.q.index != in + 1)) ||
      (newtrack && (u2.q.index != 0 && u2.q.index != 1))) {
    u2.q.index = newtrack ? 0 : (in == 0 && last_rsec == 0) ? 1 : in;
    u.q.index = bin2bcd(u2.q.index);
if (DEBUG_HEUR) fprintf(stdout, "corrected index to %x\n", u.q.index);
      result = 1;
  }

  if (u2.q.index == 1 && in == 0) {
    transitionindex1 = 1;
  } else transitionindex1 = 0;

  /* check relative position */

  if (newtrack /*u2.q.index == 0 && in != 0*/) {
    last_rsec = 60*75*u2.q.min + 75*u2.q.sec + u2.q.frame -1;
  } else if (u2.q.index == 0 && in == 0) {
    /* relative address counts backwards during index 0 */
    if (u2.q.frame > 74U ||
        u2.q.frame != (last_rsec - 1) % 75) {
      u2.q.frame = ((last_rsec - 1) % 75);
      u.q.frame = bin2bcd(u2.q.frame);
if (DEBUG_HEUR) fprintf(stdout, "corrected frame to %x\n", u.q.frame);
      result = 1;
    }
    if (u2.q.sec > 59U ||
        u2.q.sec != ((last_rsec - 1) / 75) % 60) {
      u2.q.sec = (((last_rsec - 1) / 75) % 60);
      u.q.sec = bin2bcd(u2.q.sec);
if (DEBUG_HEUR) fprintf(stdout, "corrected sec to %x\n", u.q.sec);
      result = 1;
    }
    if (u2.q.min > 59U ||
        u2.q.min != ((last_rsec - 1) / 75) / 60) {
      u2.q.min = (((last_rsec - 1) / 75) / 60);
      u.q.min = bin2bcd(u2.q.min);
if (DEBUG_HEUR) fprintf(stdout, "corrected min to %x\n", u.q.min);
      result = 1;
    }
  } else if (u2.q.index > 0) {
    if (u2.q.frame > 74U ||
        u2.q.frame != (last_rsec + 1) % 75) {
      u2.q.frame = ((last_rsec + 1) % 75);
      u.q.frame = bin2bcd(u2.q.frame);
if (DEBUG_HEUR) fprintf(stdout, "2corrected frame to %x\n", u.q.frame);
      result = 1;
    }
    if (u2.q.sec > 59U ||
        u2.q.sec != ((last_rsec + 1) / 75) % 60) {
      u2.q.sec = (((last_rsec + 1) / 75) % 60);
      u.q.sec = bin2bcd(u2.q.sec);
if (DEBUG_HEUR) fprintf(stdout, "2corrected sec to %x\n", u.q.sec);
      result = 1;
    }
    if (u2.q.min > 59U ||
        u2.q.min != ((last_rsec + 1) / 75) / 60) {
      u2.q.min = (((last_rsec + 1) / 75) / 60);
      u.q.min = bin2bcd(u2.q.min);
if (DEBUG_HEUR) fprintf(stdout, "2corrected min to %x\n", u.q.min);
      result = 1;
    }
  }

  if (u2.q.index == 1 && in == 0)
    last_rsec = -1;

  if (((u2.q.ctrl_adr & 0x0f) != 1)) {
if (DEBUG_HEUR) fprintf(stdout, "ctl_adr = %x,  zero = %x\n", u2.q.ctrl_adr, u2.q.zero);
    u.q.ctrl_adr &= 0xf0;
    u.q.ctrl_adr |= 1;
if (DEBUG_HEUR) fprintf(stdout, "corrected ctl_adr to %x\n", u.q.ctrl_adr);
    result = 1;
  }
  if (((u2.q.zero) != 0)) {
if (DEBUG_HEUR) fprintf(stdout, "zero = %x\n", u2.q.zero);
    u.q.zero = 0;
    result = 1;
  }
  if (crcres && result == 0) {
    crcres = flip_error_corr(u.b, crcres);
    if (crcres != 0) {
      crc_errors++;
    }
  }
  return result;
}

static unsigned char sectbuff[CD_FRAMESIZE_RAW + SUBSIZE];

int main(int argc, char **argv)
{
  FILE *fp;
  int i;
  unsigned char *subs;
  unsigned last_asec = 0xffffffffU;
  unsigned last_rsec = 0xffffffffU;
  unsigned count_sectors = 0;
  unsigned sectors_trackrel = 0;
  unsigned char tr=1, in=0;
  int with_data = 1;
  unsigned count_rotten_entries = 0;

  if (argc == 3 && !strcmp(argv[1], "-s")) {
    argv++; argc--;
    with_data = 0;
  }
  if (argc != 2) return 1;

  fp = fopen(argv[1], "rb");
  if (fp == NULL) return 2;

  for (;! feof(fp); count_sectors++, sectors_trackrel++ ) {
    int crcres = 0;

    if (with_data)
    {
      fread(sectbuff, CD_FRAMESIZE_RAW + SUBSIZE, 1, fp);
      subs = sectbuff + CD_FRAMESIZE_RAW;
    } else {
      fread(sectbuff, SUBSIZE, 1, fp);
      subs = sectbuff;
    }

    crcres = getQ(subs);

    if (0 != crcres) count_rotten_entries++;

    /* ignore anything beside position info */
    if (crcres == 0 && (u.q.ctrl_adr & 0x0f) != 1) {
      last_asec++;
      if (in == 0) {
        last_rsec--;
      } else {
        last_rsec++;
      }
      continue;
    }

#if 1
    for( i = 1; i >= 0 ; i--) {
      correct_heuristically(u, tr, in, last_asec, last_rsec, crcres);
      crcres = calcCRC(u.b, SUBSIZE/8);
      if (0 == crcres) {
        count_rotten_entries--;
        break;
      }
    }
#if 0
    if (0 != crcres) continue;  /* skip invalid frames */
#endif
#endif

    bcd2bin(&u.q.track);
    bcd2bin(&u.q.index);
    bcd2bin(&u.q.min);
    bcd2bin(&u.q.sec);
    bcd2bin(&u.q.frame);
    bcd2bin(&u.q.amin);
    bcd2bin(&u.q.asec);
    bcd2bin(&u.q.aframe);

    last_asec = u.q.aframe + (75*u.q.asec) + (75*60*u.q.amin) - 150;
    last_rsec = u.q.frame + (75*u.q.sec) + (75*60*u.q.min);

    if (crcres || tr == u.q.track - 1 || in != u.q.index) {
      FILE *outchannel;

      if (0 != crcres)
        outchannel = stdout;
      else {
        outchannel = stdout;
        if (tr != u.q.track) {
          sectors_trackrel = 0;
        }
      }

      fprintf(outchannel,
      "%s OK "
      "sec: %6u   MSF %2d:%02d.%02d  rel_sec: %6u   MSF %2d:%02d.%02d    t %2d, i %2d\n",
      crcres ? "NOT" : "   ",
      u.q.aframe + (75*u.q.asec) + (75*60*u.q.amin) - 150,
      u.q.amin, u.q.asec, u.q.aframe,
      u.q.frame + (75*u.q.sec) + (75*60*u.q.min),
      u.q.min, u.q.sec, u.q.frame,
      u.q.track, u.q.index);

      if (1 || 0 == crcres) {
        tr = u.q.track;
        in = u.q.index;
      }
    }
  }
  if (count_sectors && crc_errors)
    fprintf(stdout, "%u sectors with errors of %u sectors total.\n",
            crc_errors, count_sectors);
  return 0;
}
